#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TransfusionComplicationsReport : BaseTest 
	{
		private BOL.TransfusionComplicationsReport _tstTCR;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._tstTCR = new BOL.TransfusionComplicationsReport();
			this._tstTCR.TransfusionStartDate = DateTime.Now.AddYears(-1);
			this._tstTCR.TransfusionEndDate = DateTime.Now.AddYears(1);
			this._tstTCR.StartDate = DateTime.Now.AddYears(-1);
			this._tstTCR.EndDate = DateTime.Now.AddYears(1);
		}	

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.TransfusionComplicationsReport tmpTCR = new BOL.TransfusionComplicationsReport();
			Assert.IsNotNull(tmpTCR);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]		
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void DetailedReport_Pass()
		{
			try
			{
				VistALinkUnitTestHarness.RequireConnection();
				Assert.IsNotNull(this._tstTCR.DetailedReport);
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DetailedReport_Fail()
		{
		}

		[Test]
		public void ReportCriteria_Pass()
		{
			Assert.IsTrue(this._tstTCR.ReportCriteria.Length > 0);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ReportCriteria_Fail()
		{
		}

		
		[Test]
		public void TransfusionStartDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstTCR.TransfusionStartDate = tstValue;

			Assert.IsTrue(this._tstTCR.TransfusionStartDate == tstValue.Date);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void TransfusionStartDate_Fail()
		{
		}

		
		[Test]
		public void TransfusionEndDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstTCR.TransfusionEndDate = tstValue;

			Assert.IsTrue(this._tstTCR.TransfusionEndDate == tstValue.Date.AddHours(23).AddMinutes(59).AddSeconds(59));
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void TransfusionEndDate_Fail()
		{
		}

		[Test]
		public void GetTransfusionComplicationsReport_Pass()
		{
			try
			{
				VistALinkUnitTestHarness.RequireConnection();
				this._tstTCR.TransfusionStartDate = System.DateTime.Now.AddYears(-1);
				this._tstTCR.TransfusionEndDate = System.DateTime.Now.AddYears(1);
				this._tstTCR.GetTransfusionComplicationsReport();
				Assert.IsTrue(this._tstTCR.DetailedReport.Rows.Count >= 0);
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionComplicationsReport_Fail()
		{
		}

		[Test]
		public void GenerateReport_Pass()
		{
			/*try
			{
				VistALinkUnitTestHarness.RequireConnection();
				Assert.IsNotNull(this._tstTCR.DetailedReport);
				//
				gov.va.med.vbecs.reports.TransfusionComplications.TransfusionComplicationsReport mainReport = 
					this._tstTCR.GenerateReport( UnitTestConfig.User_AdministratorSupervisor );  
				//
				Assert.IsNotNull( mainReport );
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}*/
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report directly to the printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report directly to the printer
		}
	}
}

#endif
